<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Users'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <div class="w-64 bg-gray-800 text-white">
            <div class="p-4">
                <a href="dashboard" style="align-content: center;">
                <img src="/logo.png" width="50px" height="70px" align="right">
                </a>
                 <h1 class="text-2xl font-bold" style="text-align: center;" >CanIndigo</h1>
            </div>
            
            <nav class="mt-6">
                <div class="px-4 py-2 text-gray-400 text-sm font-semibold"></div>
                
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('dashboard') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-tachometer-alt w-6"></i>
                    <span class="ml-3">Dashboard</span>
                </a>
                <a href="<?php echo e(route('time-sheets.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('time-sheets.*') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-clock w-6"></i>
                    <span class="ml-3">Time Sheet</span>
                </a>
                <a href="<?php echo e(route('vehicle-usage.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('vehicle-usage.*') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-car w-6"></i>
                    <span class="ml-3">Vehicle Usage</span>
                </a>
                <a href="<?php echo e(route('expenses.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('expenses.*') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-receipt w-6"></i>
                    <span class="ml-3">Expenses Claim</span>
                </a>
                
               <!--  <a href="<?php echo e(route('users.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('users.*') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-users w-6"></i>
                    <span class="ml-3">Users</span>
                </a> -->
                
                <!-- <a href="<?php echo e(route('products.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('products.*') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-box w-6"></i>
                    <span class="ml-3">Products</span>
                </a>
                
                <a href="<?php echo e(route('orders.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('orders.*') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-shopping-cart w-6"></i>
                    <span class="ml-3">Orders</span>
                </a>
                
                <a href="<?php echo e(route('settings')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white <?php echo e(request()->routeIs('settings') ? 'bg-gray-700 text-white' : ''); ?>">
                    <i class="fas fa-cog w-6"></i>
                    <span class="ml-3">Settings</span>
                </a> -->
                
                <!-- Dropdown Menu -->
                <!-- <div class="mt-4">
                    <div class="px-4 py-2 text-gray-400 text-sm font-semibold">REPORTS</div>
                    
                    <a href="<?php echo e(route('reports.sales')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white">
                        <i class="fas fa-chart-bar w-6"></i>
                        <span class="ml-3">Sales Report</span>
                    </a>
                    
                    <a href="<?php echo e(route('reports.users')); ?>" class="flex items-center px-4 py-3 text-gray-300 hover:bg-gray-700 hover:text-white">
                        <i class="fas fa-chart-line w-6"></i>
                        <span class="ml-3">User Analytics</span>
                    </a>
                </div> -->
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Header -->
            <header class="bg-white shadow">
                <div class="flex items-center justify-between px-6 py-4">
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h2>
                    </div>
                    <div class="flex items-center space-x-4">
    <span class="text-gray-600">Welcome, <?php echo e(Auth::user()->name); ?></span>
    <div class="relative">
        <form action="<?php echo e(route('logout')); ?>" method="POST" class="inline">
            <?php echo csrf_field(); ?>
            <div class="flex items-center space-x-4">
            <button type="submit" class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center text-white">
                <i class=""></i> <?php echo e(substr(auth()->user()->name ?? 'U', 0, 1)); ?>

            </button>
            </div>
        </form>
    </div>
</div>
                    <!-- <div class="flex items-center space-x-4">
                        <span class="text-gray-600">Welcome, <?php echo e(auth()->user()->name ?? 'User'); ?></span>
                        <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center text-white">
                            <?php echo e(substr(auth()->user()->name ?? 'U', 0, 1)); ?>

                        </div>
                    </div> -->
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-6">
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>
</body>
</html><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/layouts/app.blade.php ENDPATH**/ ?>