

<?php $__env->startSection('title', 'Expense Claim Details'); ?>
<?php $__env->startSection('page-title', 'Expense Claim Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <!-- Header -->
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <div class="flex justify-between items-center">
                <h2 class="text-lg font-semibold text-gray-800">Claim Details</h2>
                <div class="flex space-x-2">
                    <a href="<?php echo e(route('expenses.index')); ?>" 
                       class="bg-gray-300 text-gray-700 px-3 py-1 rounded hover:bg-gray-400 transition duration-200 flex items-center text-sm">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                    <?php if($expense->receipt_path): ?>
                    <a href="<?php echo e(route('expenses.download-receipt', $expense)); ?>" 
                       class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700 transition duration-200 flex items-center text-sm">
                        <i class="fas fa-download mr-1"></i> Receipt
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Content -->
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Left Column -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500">Description</label>
                        <p class="mt-1 text-sm text-gray-900 font-medium"><?php echo e($expense->description); ?></p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-500">Category</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($expense->category->name); ?></p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-500">Amount</label>
                        <p class="mt-1 text-lg font-semibold text-green-600">OMR-<?php echo e(number_format($expense->amount, 2)); ?></p>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-500">Expense Date</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($expense->expense_date->format('F d, Y')); ?></p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-500">Client Site</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($expense->clientSite->name); ?></p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-500">Status</label>
                        <p class="mt-1">
                            <?php if($expense->status == 'approved'): ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-2"></i> Approved
                                </span>
                            <?php elseif($expense->status == 'rejected'): ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                                    <i class="fas fa-times-circle mr-2"></i> Rejected
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-clock mr-2"></i> Pending Review
                                </span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Business Purpose -->
            <div class="border-t border-gray-200 pt-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Business Purpose</label>
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-sm text-gray-900"><?php echo e($expense->business_purpose); ?></p>
                </div>
            </div>

            <!-- Receipt Section -->
            <?php if($expense->receipt_path): ?>
            <div class="border-t border-gray-200 pt-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Receipt</label>
                <div class="bg-gray-50 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-file-invoice text-gray-400 text-2xl mr-3"></i>
                            <div>
                                <p class="text-sm font-medium text-gray-900">Uploaded Receipt</p>
                                <!-- <p class="text-xs text-gray-500">Click download to view the receipt</p> -->
                            </div>
                        </div>
                        <!-- <a href="<?php echo e(route('expenses.download-receipt', $expense)); ?>" 
                           class="bg-blue-600 text-white px-3 py-2 rounded hover:bg-blue-700 transition duration-200 flex items-center text-sm">
                            <i class="fas fa-download mr-2"></i> Download
                        </a> -->
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Admin Notes (if any) -->
            <?php if($expense->admin_notes): ?>
            <div class="border-t border-gray-200 pt-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Admin Notes</label>
                <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                    <p class="text-sm text-yellow-800"><?php echo e($expense->admin_notes); ?></p>
                </div>
            </div>
            <?php endif; ?>

            <!-- Timestamps -->
            <div class="border-t border-gray-200 pt-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-xs text-gray-500">
                    <div>
                        <span class="font-medium">Submitted:</span> 
                        <?php echo e($expense->created_at->format('M d, Y \\a\\t h:i A')); ?>

                    </div>
                    <div>
                        <span class="font-medium">Last Updated:</span> 
                        <?php echo e($expense->updated_at->format('M d, Y \\a\\t h:i A')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/expenses/show.blade.php ENDPATH**/ ?>