@extends('layouts.app')

@section('title', 'Vehicle Usage Details- Canindigo INC')
@section('page-title', 'Vehicle Usage Details')

@section('content')
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-medium text-gray-500">Vehicle</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->vehicle->registration_number ?? 'N/A' }}</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">User</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->user->name ?? 'N/A' }}</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Date</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->date->format('F d, Y') }}</p>
                <p class="text-sm text-gray-500">{{ $vehicleUsage->date->format('l') }}</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Trip Purpose</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->trip_purpose }}</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Start KM</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->start_km }} KM</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">End KM</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->end_km }} KM</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Total Distance</h4>
                <p class="mt-1 text-lg font-semibold text-blue-600">
                    {{ $vehicleUsage->end_km - $vehicleUsage->start_km }} KM
                </p>
            </div>

            @if($vehicleUsage->fuel_consumption)
            <div>
                <h4 class="text-sm font-medium text-gray-500">Fuel Consumption</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $vehicleUsage->fuel_consumption }} L</p>
            </div>
            @endif

            @if($vehicleUsage->receipt_path)
            <div class="md:col-span-2">
                <h4 class="text-sm font-medium text-gray-500">Receipt</h4>
                <div class="mt-2">
                    <img src="{{ asset('storage/' . $vehicleUsage->receipt_path) }}" 
                         alt="Receipt" 
                         class="max-w-xs rounded-lg shadow-md border">
                    <div class="mt-2">
                        <a href="{{ asset('storage/' . $vehicleUsage->receipt_path) }}" 
                           target="_blank" 
                           class="text-blue-600 hover:text-blue-800 text-sm">
                            View Full Size
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <div class="mt-6 flex justify-end space-x-3">
            <a href="{{ route('vehicle-usage.index') }}" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 transition duration-200">
                Back to List
            </a>
            <a href="{{ route('vehicle-usage.edit', $vehicleUsage) }}" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition duration-200">
                Edit Entry
            </a>
        </div>
    </div>
</div>
@endsection