<?php
// database/migrations/2024_01_15_000000_create_project_codes_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectCodesTable extends Migration
{
    public function up()
    {
        Schema::create('project_codes', function (Blueprint $table) {
            $table->id();
            $table->string('project_name');
            $table->text('description')->nullable();
            $table->decimal('price', 12, 2)->nullable(); // Total budget
        });
    }

    public function down()
    {
        Schema::dropIfExists('project_codes');
    }
}