// app/Helpers/MenuHelper.php
<?php

namespace App\Helpers;

use Auth;

class MenuHelper
{
    public static function getMenuItems()
    {
        $user = Auth::user();
        
        if (!$user) {
            return self::getGuestMenu();
        }

        switch ($user->role) {
            case 'admin':
                return self::getAdminMenu();
            case 'management':
                return self::getManagerMenu();
                case 'leader':
                return self::getLeaderMenu();
            case 'user':
                return self::getUserMenu();
            default:
                return self::getGuestMenu();
        }
    }

    private static function getAdminMenu()
    {
        return [
            ['name' => 'Dashboard', 'route' => 'dashboard', 'icon' => 'fa-dashboard'],
            ['name' => 'User Management', 'route' => 'users.index', 'icon' => 'fa-users'],
            ['name' => 'Settings', 'route' => 'settings', 'icon' => 'fa-cog'],
            ['name' => 'Reports', 'route' => 'reports', 'icon' => 'fa-chart-bar'],
        ];
    }

    private static function getManagementMenu()
    {
        return [
            ['name' => 'Dashboard', 'route' => 'dashboard', 'icon' => 'fa-dashboard'],
            ['name' => 'Team Management', 'route' => 'team', 'icon' => 'fa-users'],
            ['name' => 'Reports', 'route' => 'reports', 'icon' => 'fa-chart-bar'],
        ];
    }
     private static function getLeaderMenu()
    {
        return [
            ['name' => 'Dashboard', 'route' => 'dashboard', 'icon' => 'fa-dashboard'],
            ['name' => 'Team Management', 'route' => 'team', 'icon' => 'fa-users'],
            ['name' => 'Reports', 'route' => 'reports', 'icon' => 'fa-chart-bar'],
        ];
    }

    private static function getUserMenu()
    {
        return [
            ['name' => 'Dashboard', 'route' => 'dashboard', 'icon' => 'fa-dashboard'],
            ['name' => 'Time Sheet', 'route' => 'time-sheets', 'icon' => 'fa-clock'],
            ['name' => 'vehicle Usage', 'route' => 'vehicle-usage', 'icon' => 'fa-car'],
            ['name' => 'Expences', 'route' => 'expense', 'icon' => 'fa-money'],
        ];
    }

    private static function getGuestMenu()
    {
        return [
            ['name' => 'Login', 'route' => 'login', 'icon' => 'fa-sign-in'],
            ['name' => 'Register', 'route' => 'register', 'icon' => 'fa-user-plus'],
        ];
    }
}