<?php
// app/Console/Commands/RehashPasswords.php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class RehashPasswords extends Command
{
    protected $signature = 'passwords:rehash';
    protected $description = 'Rehash all user passwords with Bcrypt';

    public function handle()
    {
        $users = User::all();

        foreach ($users as $user) {
            // Check if password is already hashed but not with Bcrypt
            // Or if it's plain text, hash it with Bcrypt
            if (!$this->isBcrypt($user->password)) {
                $user->password = Hash::make($user->password);
                $user->save();
                $this->info("Rehashed password for user: {$user->email}");
            }
        }

        $this->info('All passwords have been rehashed with Bcrypt.');
    }

    private function isBcrypt($password)
    {
        // Bcrypt hashes start with $2y$
        return preg_match('/^\$2y\$/', $password);
    }
}